--[[http://pastie.org/pastes/1519794/]]

local NumStepsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 99, diffuse = color("0,1,1,1") },
	{ UpperLimit = 179, diffuse = color("0.2,1,0.2,1") },
	{ UpperLimit = 329, diffuse = color("1,1,0,1") },
	{ UpperLimit = 499, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};
local CourseNumStepsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 599, diffuse = color("0,1,1,1") },
	{ UpperLimit = 999, diffuse = color("0.2,1,0.2,1") },
	{ UpperLimit = 1499, diffuse = color("1,1,0,1") },
	{ UpperLimit = 1999, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};

local JumpsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 19, diffuse = color("0,1,1,1") },
	{ UpperLimit = 39, diffuse = color("0.2,1,0.2,1") },
	{ UpperLimit = 74, diffuse = color("1,1,0,1") },
	{ UpperLimit = 99, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};
local CourseJumpsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 49, diffuse = color("0,1,1,1") },
	{ UpperLimit = 99, diffuse = color("0.2,1,0.2,1") },
	{ UpperLimit = 164, diffuse = color("1,1,0,1") },
	{ UpperLimit = 249, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};

local HoldsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 14, diffuse = color("0,1,1,1") },
	{ UpperLimit = 29, diffuse = color("0.2,1,0.2,1") },
	{ UpperLimit = 49, diffuse = color("1,1,0,1") },
	{ UpperLimit = 74, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};
local CourseHoldsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 34, diffuse = color("0,1,1,1") },
	{ UpperLimit = 69, diffuse = color("0.2,1,0.2,1") },
	{ UpperLimit = 119, diffuse = color("1,1,0,1") },
	{ UpperLimit = 179, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};

local MinesColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 9, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};
local CourseMinesColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 49, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};

local HandsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 9, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};
local CourseHandsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 49, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};

local RollsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 9, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};
local CourseRollsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 49, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};

local LiftsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 9, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};
local CourseLiftsColors = {
	{ UpperLimit = 0, diffuse = color("1,1,1,0.5") },
	{ UpperLimit = 49, diffuse = color("1,0.5,0.2,1") },
	{ UpperLimit = 9999999, diffuse = color("1,0,0.2,1") },
	{ UpperLimit = nil, diffuse = color("1,1,1,0.5") },
};

function PaneValueToColor(category,value)
	local numValue = tonumber(value)
	local t;
	if not GAMESTATE:IsCourseMode() and category == 'RadarCategory_TapsAndHolds' then
		t = NumStepsColors
	elseif GAMESTATE:IsCourseMode() and category == 'RadarCategory_TapsAndHolds' then
		t = CourseNumStepsColors
	end;

	if not GAMESTATE:IsCourseMode() and category == 'RadarCategory_Jumps' then
		t = JumpsColors
	elseif GAMESTATE:IsCourseMode() and category == 'RadarCategory_Jumps' then
		t = CourseJumpsColors
	end;

	if not GAMESTATE:IsCourseMode() and category == 'RadarCategory_Holds' then
		t = HoldsColors
	elseif GAMESTATE:IsCourseMode() and category == 'RadarCategory_Holds' then
		t = CourseHoldsColors
	end;

	if not GAMESTATE:IsCourseMode() and category == 'RadarCategory_Mines' then
		t = MinesColors
	elseif GAMESTATE:IsCourseMode() and category == 'RadarCategory_Mines' then
		t = CourseMinesColors
	end;

	if not GAMESTATE:IsCourseMode() and category == 'RadarCategory_Hands' then
		t = HandsColors
	elseif GAMESTATE:IsCourseMode() and category == 'RadarCategory_Hands' then
		t = CourseHandsColors
	end;

	if not GAMESTATE:IsCourseMode() and category == 'RadarCategory_Rolls' then
		t = RollsColors
	elseif GAMESTATE:IsCourseMode() and category == 'RadarCategory_Rolls' then
		t = CourseRollsColors
	end;

	if not GAMESTATE:IsCourseMode() and category == 'RadarCategory_Lifts' then
		t = LiftsColors
	elseif GAMESTATE:IsCourseMode() and category == 'RadarCategory_Lifts' then
		t = CourseLiftsColors
	end;

	for i=1,#t do
		if numValue == nil then
			return t[i].diffuse
		elseif numValue <= t[i].UpperLimit then
			return t[i].diffuse
		end
	end
end
